# ---------------------------------------------------------------------
# Author:    Dr. Holger Schwichtenberg
# Desc:      PowerShell Commandlets for handling LDAP-Objects
# Usage:     This file contains a function-based Commandlet.  In order to use
#            it, you must dot source the file into your shell e.g.:
#            PH> . c:\PSExtensions\LDAP_Commandlets.ps1
# Date:      10/05/2006 
# Version:	 2.0 
# Host:      PowerShell Version 1.0 RC2
# ---------------------------------------------------------------------

function Test-LDAPCommandlets
{
"OU anlegen..."
Add-LDAPObject "LDAP://xfilesserver/OU=Agents,DC=FBI,DC=net" -class "organizationalUnit" -rdn "ou=formerAgents"
"Benutzer anlegen..."
Add-LDAPObject "LDAP://xfilesserver/ou=formerAgents,OU=Agents,DC=FBI,DC=net" "user" "cn=AlexKrycek" 
"Auflisten..."
Get-LDAPChildren "LDAP://xfilesserver/ou=formerAgents,OU=Agents,DC=FBI,DC=net"
"Alle Objekte im Container löschen..."
Get-LDAPChildren "LDAP://xfilesserver/ou=formerAgents,OU=Agents,DC=FBI,DC=net" | Remove-LDAPObject | select name
"Container selbst löschen..."
Remove-LDAPObject "LDAP://xfilesserver/ou=formerAgents,OU=Agents,DC=FBI,DC=net" | select name 
}

function Test-LDAPCommandlets2
{
"OU anlegen..."
Add-LDAPObject "LDAP://E02/OU=Dozenten,DC=IT-Visions,DC=local" -class "organizationalUnit" -rdn "ou=DOTNETDozenten"
"Benutzer anlegen..."
Add-LDAPObject "LDAP://E02/ou=DOTNETDozenten, OU=Dozenten,DC=IT-Visions,DC=local" "user" "cn=DrHolgerSchwichtenberg"
"Auflisten..."
Get-LDAPChildren "LDAP://E02/ou=DOTNETDozenten, OU=Dozenten,DC=IT-Visions,DC=local"
"Alle Objekte im Container löschen..."
Get-LDAPChildren "LDAP://E02/ou=DOTNETDozenten, OU=Dozenten,DC=IT-Visions,DC=local" | Remove-LDAPObject | select name
"Container selbst löschen..."
Remove-LDAPObject "LDAP://E02/ou=DOTNETDozenten, OU=Dozenten,DC=IT-Visions,DC=local" | select name 
}


# Get single LDAP object
function Get-LDAPObject {
    param([string[]]$LDAPPath)
        
    begin {   
    }
    
    process {
	 if ($_)
	 {
	   if ($_ -is [string])
	   {
	    new-object system.directoryservices.directoryEntry($_) 
	   }
	   else
	   { throw "Pipeline input must be [string]." 
	   }
	 }
    }
      
    end {
        if ($LDAPPath) {
          foreach ($Path in $LDAPPath) {
            new-object system.directoryservices.directoryEntry($Path) 
          }
        }
    }
}

# Hilfsroutine
function getContainer([string] $path)
{
$con = new-object system.directoryservices.directoryEntry($path) 
$con.PSBase.Children
}
	
# Get content of an LDAP container
function Get-LDAPChildren {
    param([string[]]$LDAPPath)
        
    begin {      }
    
    process {
    if ($_)
	 {
	   if ($_ -is [string])
	   {
        getContainer($_)
	   }
       elseif ($_ -is [System.DirectoryServices.DirectoryEntry])
	   {      
 	    getContainer($_.PSBase.Path) 
	   }
	   else
	   { throw "Pipeline input must be [string] or [System.DirectoryServices.DirectoryEntry]." 
	   }
	 }
    }
      
    end {
        if ($LDAPPath) {
          foreach ($Path in $LDAPPath) {
           getContainer($Path) 
          }
        }
    }
}

# Remove an object from an LDAP container
function Remove-LDAPObject {
    param([string[]]$LDAPPath)
        
    begin {  
	
	function remove([string] $path)
	{
	
	if ([system.directoryservices.directoryEntry]::Exists($path))
     {
	  $obj = new-object system.directoryservices.directoryEntry($path) 
      $obj.PSBase.DeleteTree()
	  $obj
     }
	else
	 {
	 throw "Object does not exists!"
	 }
	}
    }
    
    process {
    if ($_)
	 {
	   if ($_ -is [string])
	   {
        remove($_)
	   }
       elseif ($_ -is [System.DirectoryServices.DirectoryEntry])
	   {      
 	    remove($_.PSBase.Path) 
	   }
	   else
	   { throw "Pipeline input must be [string] or [System.DirectoryServices.DirectoryEntry]." 
	   }
	 }
    }
      
    end {
        if ($LDAPPath) {
          foreach ($Path in $LDAPPath) {
           remove($Path) 
          }
        }
    }
}


# Add an new object to an LDAP container
function Add-LDAPObject {
    param([string]$Container, [string]$Class, [string]$RDN)
        
    begin {  } 
    
    process { }
 
      
    end {
    if ($Container -and $Class -and $RDN) {
        
		 Write-Warning "Adding Object $RDN of type $Class to $Container"
	if ([system.directoryservices.directoryEntry]::Exists($Container))
     {
	
	  $obj = new-object system.directoryservices.directoryEntry($Container) 
	  $newobj = $obj.PSBase.Children.Add([string]$RDN,[string]$Class)
      $newobj.PSBase.CommitChanges()
     }
	else
	 {
	 throw "Container does not exists!"
	 }
	}
    }
}

# Define aliases for commandlet functions
Set-Alias LDP Get-LDAPObject
Set-Alias LDC Get-LDAPObject
Set-Alias RLDP RemoveLDAPObject
Set-Alias ALDP Add-LDAPObject

# Confirm installation
"Function-based commandlets for LDAP successfully installed!"